<?php
require_once 'includes/auth.php';

$msg = '';
$msgType = 'success';
$createdAccounts = [];

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $act = $_POST['action'] ?? '';

    try {
        if ($act === 'create_demos') {
            $prefix = strtoupper(trim($_POST['prefix'] ?? 'DEMO'));
            $count = (int)($_POST['count'] ?? 1);
            $balance = (float)($_POST['balance'] ?? 100);
            $pass = trim($_POST['password'] ?? '123456');

            if (!$prefix) throw new Exception("Prefix is required.");
            if ($count < 1 || $count > 50) throw new Exception("Count must be between 1 and 50.");
            if ($balance < 0) throw new Exception("Starting balance cannot be negative.");
            if (strlen($pass) < 6) throw new Exception("Password must be at least 6 characters.");

            $pwHash = password_hash($pass, PASSWORD_BCRYPT);
            
            $db->beginTransaction();
            for ($i = 1; $i <= $count; $i++) {
                $uid = $prefix . rand(1000, 9999) . $i;
                $phone = '9' . rand(100000000, 999999999);
                
                $stmt = $db->prepare("INSERT INTO users (user_id, phone, password, balance) VALUES (?, ?, ?, ?)");
                $stmt->execute([$uid, $phone, $pwHash, $balance]);

                $createdAccounts[] = [
                    'user_id' => $uid,
                    'phone'   => $phone,
                    'balance' => $balance
                ];
            }
            $db->commit();
            
            $msg = "Successfully generated $count demo account(s).";
            $msgType = 'success';
        }

        if ($act === 'change_pass') {
            $newPass = trim($_POST['new_pass'] ?? '');
            if (strlen($newPass) < 6) throw new Exception("New admin password must be at least 6 characters.");
            
            $adminUser = $_SESSION['admin_user'];
            $hash = password_hash($newPass, PASSWORD_BCRYPT);
            
            $stmt = $db->prepare("UPDATE admins SET password_hash = ? WHERE username = ?");
            $stmt->execute([$hash, $adminUser]);
            
            $msg = "Admin password updated successfully.";
            $msgType = 'success';
        }
    } catch (Exception $e) {
        if ($db->inTransaction()) $db->rollBack();
        $msg = $e->getMessage();
        $msgType = 'error';
    }
}

require_once 'includes/header.php';
?>

<div class="mb-8">
    <h1 class="text-2xl font-bold text-white tracking-tight flex items-center gap-2">
        <i data-feather="terminal" class="w-6 h-6 text-emerald-500"></i> Account Demaker
    </h1>
    <p class="text-sm text-slate-400 mt-1">Batch generate loaded test accounts and manage primary admin credentials.</p>
</div>

<?php if($msg): ?>
    <div class="mb-6 p-4 rounded-xl flex items-start gap-3 border <?= $msgType === 'success' ? 'bg-green-500/10 border-green-500/20 text-green-400' : 'bg-red-500/10 border-red-500/20 text-red-400' ?>">
        <i data-feather="<?= $msgType === 'success' ? 'check-circle' : 'alert-circle' ?>" class="w-5 h-5 shrink-0 mt-0.5"></i>
        <p class="text-sm font-medium"><?= h($msg) ?></p>
    </div>
<?php endif; ?>

<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
    
    <!-- Generate Accounts Card -->
    <div class="border border-slate-700/50 bg-slate-800/50 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 p-6 relative overflow-hidden">
        <div class="absolute -right-6 -bottom-6 w-40 h-40 bg-emerald-500/10 rounded-full blur-2xl pointer-events-none"></div>
        <h2 class="text-lg font-bold text-white flex items-center gap-2 mb-6 relative z-10">
            <i data-feather="zap" class="w-5 h-5 text-emerald-400"></i> Generate Demo Accounts
        </h2>
        
        <form method="POST" class="flex flex-col gap-4 relative z-10">
            <input type="hidden" name="action" value="create_demos">
            
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="text-xs font-bold text-slate-400 uppercase tracking-widest pl-1 mb-2 block">ID Prefix</label>
                    <input type="text" name="prefix" value="DEMO" placeholder="e.g. DEMO" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 text-white placeholder:text-slate-600 focus:outline-none focus:border-emerald-500 transition-colors uppercase font-mono tracking-wider font-bold" required>
                </div>
                <div>
                    <label class="text-xs font-bold text-slate-400 uppercase tracking-widest pl-1 mb-2 block">Quantity</label>
                    <input type="number" name="count" value="1" min="1" max="50" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-emerald-500 transition-colors font-bold text-center" required>
                </div>
            </div>

            <div>
                <label class="text-xs font-bold text-slate-400 uppercase tracking-widest pl-1 mb-2 block">Starting Balance (₹)</label>
                <input type="number" step="0.1" name="balance" value="100" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-emerald-500 transition-colors font-bold text-center" required>
            </div>

            <div>
                <label class="text-xs font-bold text-slate-400 uppercase tracking-widest pl-1 mb-2 block">Uniform Password</label>
                <input type="text" name="password" value="123456" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-emerald-500 transition-colors font-mono tracking-wider text-center" required>
            </div>

            <button type="submit" class="w-full bg-emerald-600 hover:bg-emerald-500 text-white mt-2 py-3.5 rounded-xl font-bold transition-all shadow-lg shadow-emerald-600/20 border border-emerald-500/50 flex items-center justify-center gap-2">
                <i data-feather="cpu" class="w-4 h-4"></i> Synthesize Accounts
            </button>
        </form>
    </div>

    <div class="flex flex-col gap-6">
        <!-- Admin Security Card -->
        <div class="border border-red-500/20 bg-gradient-to-br from-red-900/10 to-red-950/20 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 p-6 h-fit relative">
            <h2 class="text-lg font-bold text-white flex items-center gap-2 mb-6">
                <i data-feather="shield" class="w-5 h-5 text-red-500"></i> Admin Access Keys
            </h2>
            
            <form method="POST" class="flex flex-col gap-4">
                <input type="hidden" name="action" value="change_pass">
                <div>
                    <label class="text-xs font-bold text-red-400/80 uppercase tracking-widest pl-1 mb-2 block">New Panel Password</label>
                    <input type="password" name="new_pass" placeholder="••••••••" class="w-full bg-slate-900/80 border border-red-500/30 rounded-xl px-4 py-3 text-white placeholder:text-slate-600 focus:outline-none focus:border-red-500 transition-colors" required>
                </div>
                <button type="submit" class="w-full bg-red-600/20 hover:bg-red-600/40 text-red-400 border border-red-500/30 py-3.5 rounded-xl font-bold transition-colors flex items-center justify-center gap-2" onsubmit="return confirm('You will be logged out upon success. Continue?');">
                    <i data-feather="key" class="w-4 h-4"></i> Rotate Admin Password
                </button>
            </form>
        </div>

        <!-- Render Output if Accounts generated -->
        <?php if(!empty($createdAccounts)): ?>
        <div class="border border-slate-700/50 bg-slate-800/80 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 p-6 flex flex-col flex-1">
            <h2 class="text-sm font-bold text-white flex items-center gap-2 mb-4 uppercase tracking-widest">
                <i data-feather="clipboard" class="w-4 h-4 text-emerald-500"></i> Generated Fleet
            </h2>
            <div class="bg-slate-900 rounded-xl p-4 overflow-y-auto max-h-[160px] font-mono text-xs flex-1 border border-slate-800 text-slate-300">
                <?php foreach($createdAccounts as $c): ?>
                    <div class="mb-1.5 pb-1.5 border-b border-slate-700/50 last:border-0 last:mb-0 last:pb-0">
                        UID: <span class="text-emerald-400 font-bold"><?= $c['user_id'] ?></span>
                        | Phone: <span><?= $c['phone'] ?></span>
                        | Bal: <span class="text-green-400">₹<?= money($c['balance']) ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
            <p class="text-[10px] text-slate-500 text-center mt-3 tracking-wide">Copy these credentials before leaving this page.</p>
        </div>
        <?php endif; ?>
    </div>

</div>

<?php require_once 'includes/footer.php'; ?>
