<?php
session_start();

// Strict 2-Hour Timeout (7200 seconds)
$timeout_duration = 7200;

if (isset($_SESSION['owner_last_activity']) && (time() - $_SESSION['owner_last_activity']) > $timeout_duration) {
    session_unset();
    session_destroy();
    header("Location: /owner/index.php?error=Session expired. Please log in again.");
    exit();
}
$_SESSION['owner_last_activity'] = time();

if (!isset($_SESSION['owner_logged_in']) || $_SESSION['owner_logged_in'] !== true) {
    header("Location: /owner/index.php");
    exit();
}

// Global Database Connection
require_once __DIR__ . '/../../backend/core/env_loader.php';
load_env(__DIR__ . '/../../.env');

define('DB_HOST', env('DB_HOST', 'localhost'));
define('DB_NAME', env_required('DB_NAME'));
define('DB_USER', env_required('DB_USER'));
define('DB_PASS', env_required('DB_PASS'));

// Helper Functions ported from ambrat.php
function get_db(): PDO {
    static $pdo = null;
    if ($pdo) return $pdo;
    try {
        $dsn = 'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4';
        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]);
    } catch (PDOException $e) {
        die("Database Connection Error. Please check configuration.");
    }
    return $pdo;
}

function h(?string $str): string {
    return htmlspecialchars($str ?? '', ENT_QUOTES, 'UTF-8');
}

function money($amt): string {
    return number_format((float)$amt, 2);
}

// Initialize Global DB Object for included files
$db = get_db();
?>
