<?php
require_once 'includes/auth.php';

$msg = '';
$msgType = 'success';

// Handle Setting Updates
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // --- Game Difficulty Mode ---
    if (isset($_POST['action']) && $_POST['action'] === 'update_difficulty') {
        $mode = trim($_POST['game_difficulty'] ?? 'medium');
        if (!in_array($mode, ['easy', 'medium', 'hard'])) $mode = 'medium';
        try {
            $stmt = $db->prepare("INSERT INTO settings (k, v) VALUES ('game_difficulty', ?) ON DUPLICATE KEY UPDATE v = ?");
            $stmt->execute([$mode, $mode]);
            $msg = "Game difficulty set to <strong>" . strtoupper(h($mode)) . "</strong>. All games (Mines, Wingo, Crash) now use this mode.";
            $msgType = 'success';
        } catch (Exception $e) {
            $msg = "Failed to update difficulty: " . $e->getMessage();
            $msgType = 'error';
        }
    }

    // --- Deposit Bonuses ---
    if (isset($_POST['action']) && $_POST['action'] === 'update_bonuses') {
        $b1 = (float)($_POST['bonus_1st'] ?? 0);
        $b2 = (float)($_POST['bonus_2nd'] ?? 0);
        $b3 = (float)($_POST['bonus_3rd'] ?? 0);
        $bReg = (float)($_POST['bonus_register'] ?? 0);

        try {
            $db->beginTransaction();
            $stmt = $db->prepare("INSERT INTO settings (k, v) VALUES (?, ?) ON DUPLICATE KEY UPDATE v = ?");
            $stmt->execute(['bonus_1st_dep', $b1, $b1]);
            $stmt->execute(['bonus_2nd_dep', $b2, $b2]);
            $stmt->execute(['bonus_3rd_dep', $b3, $b3]);
            $stmt->execute(['bonus_register', $bReg, $bReg]);
            $db->commit();
            $msg = "Deposit welcome bonus percentages updated successfully.";
            $msgType = 'success';
        } catch (Exception $e) {
            if ($db->inTransaction()) $db->rollBack();
            $msg = "Failed to update settings: " . $e->getMessage();
            $msgType = 'error';
        }
    }
}

// Fetch current settings
$settingsMap = $db->query("SELECT k, v FROM settings")->fetchAll(PDO::FETCH_KEY_PAIR);

$bonus1   = (float)($settingsMap['bonus_1st_dep'] ?? 0);
$bonus2   = (float)($settingsMap['bonus_2nd_dep'] ?? 0);
$bonus3   = (float)($settingsMap['bonus_3rd_dep'] ?? 0);
$bonusReg = (float)($settingsMap['bonus_register'] ?? 0);
$currentDifficulty = $settingsMap['game_difficulty'] ?? 'medium';
if (!in_array($currentDifficulty, ['easy', 'medium', 'hard'])) $currentDifficulty = 'medium';

require_once 'includes/header.php';
?>

<div class="mb-8">
    <h1 class="text-2xl font-bold text-white tracking-tight flex items-center gap-2">
        <i data-feather="settings" class="w-6 h-6 text-indigo-500"></i> Global Settings
    </h1>
    <p class="text-sm text-slate-400 mt-1">Configure game difficulty, automated system mechanics, and welcome bonuses.</p>
</div>

<?php if($msg): ?>
    <div class="mb-6 p-4 rounded-xl flex items-start gap-3 border <?= $msgType === 'success' ? 'bg-green-500/10 border-green-500/20 text-green-400' : 'bg-red-500/10 border-red-500/20 text-red-400' ?>">
        <i data-feather="<?= $msgType === 'success' ? 'check-circle' : 'alert-circle' ?>" class="w-5 h-5 shrink-0 mt-0.5"></i>
        <p class="text-sm font-medium"><?= $msg ?></p>
    </div>
<?php endif; ?>

<!-- ══════════════════════════════════════════════
     GAME DIFFICULTY MODE
══════════════════════════════════════════════ -->
<div class="border border-slate-700/50 bg-slate-800/50 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 p-6 mb-6 relative overflow-hidden">
    <div class="absolute -left-8 -top-8 w-40 h-40 bg-purple-500/10 rounded-full blur-2xl pointer-events-none"></div>
    <div class="relative z-10">
        <h2 class="text-lg font-bold text-white flex items-center gap-2 mb-1">
            <i data-feather="sliders" class="w-5 h-5 text-purple-400"></i> Game Difficulty Mode
            <span class="ml-2 text-xs font-bold px-3 py-1 rounded-full <?=
                $currentDifficulty === 'easy'   ? 'bg-green-500/20 text-green-400'  :
                ($currentDifficulty === 'medium' ? 'bg-yellow-500/20 text-yellow-400' :
                                                   'bg-red-500/20 text-red-400')
            ?>">
                <?= strtoupper(h($currentDifficulty)) ?> ACTIVE
            </span>
        </h2>
        <p class="text-[11px] text-slate-400 uppercase tracking-widest font-bold mb-6">
            Controls win probability for Mines · Wingo 1min · Wingo 30s · Crash — for all players.
        </p>

        <form method="POST">
            <input type="hidden" name="action" value="update_difficulty">
            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-5">

                <!-- Easy -->
                <label class="relative cursor-pointer">
                    <input type="radio" name="game_difficulty" value="easy" class="sr-only peer" <?= $currentDifficulty === 'easy' ? 'checked' : '' ?>>
                    <div class="p-5 rounded-xl border-2 transition-all
                        peer-checked:border-green-500 peer-checked:bg-green-500/10
                        border-slate-700 bg-slate-900/50 hover:border-green-500/40">
                        <div class="text-3xl mb-2">🟢</div>
                        <div class="font-bold text-white text-base">Easy</div>
                        <div class="text-xs text-slate-400 mt-1 leading-relaxed">Truly random outcomes — fair chance to win</div>
                        <?php if ($currentDifficulty === 'easy'): ?>
                            <div class="mt-3 text-xs font-bold text-green-400">✓ Currently Active</div>
                        <?php endif; ?>
                    </div>
                </label>

                <!-- Medium -->
                <label class="relative cursor-pointer">
                    <input type="radio" name="game_difficulty" value="medium" class="sr-only peer" <?= $currentDifficulty === 'medium' ? 'checked' : '' ?>>
                    <div class="p-5 rounded-xl border-2 transition-all
                        peer-checked:border-yellow-500 peer-checked:bg-yellow-500/10
                        border-slate-700 bg-slate-900/50 hover:border-yellow-500/40">
                        <div class="text-3xl mb-2">🟡</div>
                        <div class="font-bold text-white text-base">Medium</div>
                        <div class="text-xs text-slate-400 mt-1 leading-relaxed">55% house edge — players lose more often</div>
                        <?php if ($currentDifficulty === 'medium'): ?>
                            <div class="mt-3 text-xs font-bold text-yellow-400">✓ Currently Active</div>
                        <?php endif; ?>
                    </div>
                </label>

                <!-- Hard -->
                <label class="relative cursor-pointer">
                    <input type="radio" name="game_difficulty" value="hard" class="sr-only peer" <?= $currentDifficulty === 'hard' ? 'checked' : '' ?>>
                    <div class="p-5 rounded-xl border-2 transition-all
                        peer-checked:border-red-500 peer-checked:bg-red-500/10
                        border-slate-700 bg-slate-900/50 hover:border-red-500/40">
                        <div class="text-3xl mb-2">🔴</div>
                        <div class="font-bold text-white text-base">Hard</div>
                        <div class="text-xs text-slate-400 mt-1 leading-relaxed">95% house edge — players win only ~5% of the time</div>
                        <?php if ($currentDifficulty === 'hard'): ?>
                            <div class="mt-3 text-xs font-bold text-red-400">✓ Currently Active</div>
                        <?php endif; ?>
                    </div>
                </label>

            </div>
            <button type="submit" class="w-full sm:w-auto px-8 bg-purple-600 hover:bg-purple-500 text-white py-3 rounded-xl font-bold transition-all shadow-lg shadow-purple-600/20 border border-purple-500/50 flex items-center justify-center gap-2">
                <i data-feather="save" class="w-4 h-4"></i> Save Difficulty Mode
            </button>
        </form>
    </div>
</div>

<!-- ══════════════════════════════════════════════
     DEPOSIT BONUSES
══════════════════════════════════════════════ -->
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
    <div class="border border-slate-700/50 bg-slate-800/50 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 p-6 relative overflow-hidden">
        <div class="absolute -right-6 -bottom-6 w-40 h-40 bg-indigo-500/10 rounded-full blur-2xl pointer-events-none"></div>
        <h2 class="text-lg font-bold text-white flex items-center gap-2 mb-2 relative z-10">
            <i data-feather="gift" class="w-5 h-5 text-indigo-400"></i> Welcome Deposit Bonuses
        </h2>
        <p class="text-[11px] text-slate-400 uppercase tracking-widest font-bold mb-6">Automatically credits extra % on specific deposits.</p>
        
        <form method="POST" class="flex flex-col gap-5 relative z-10">
            <input type="hidden" name="action" value="update_bonuses">
            
            <div>
                <label class="text-xs font-bold text-slate-300 uppercase tracking-widest pl-1 mb-2 block flex items-center gap-1.5"><i data-feather="user-plus" class="w-4 h-4 text-emerald-400"></i> New Registration Bonus (Flat ₹)</label>
                <div class="relative">
                    <span class="absolute left-4 top-1/2 -translate-y-1/2 text-slate-500 font-bold">₹</span>
                    <input type="number" step="0.1" min="0" max="100000" name="bonus_register" value="<?= $bonusReg ?>" class="w-full bg-slate-900 border border-slate-700 rounded-xl pl-10 py-3 pr-4 text-white focus:outline-none focus:border-indigo-500 transition-colors font-bold text-lg text-emerald-400" required>
                </div>
            </div>

            <hr class="border-slate-700/50 my-2">

            <div>
                <label class="text-xs font-bold text-slate-300 uppercase tracking-widest pl-1 mb-2 block flex items-center gap-1.5"><span class="bg-indigo-500 text-white w-4 h-4 rounded-full flex items-center justify-center text-[10px]">1</span> 1st Deposit Bonus (%)</label>
                <div class="relative">
                    <input type="number" step="0.1" min="0" max="1000" name="bonus_1st" value="<?= $bonus1 ?>" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 pr-10 text-white focus:outline-none focus:border-indigo-500 transition-colors font-bold text-lg" required>
                    <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 font-bold">%</span>
                </div>
            </div>

            <div>
                 <label class="text-xs font-bold text-slate-300 uppercase tracking-widest pl-1 mb-2 block flex items-center gap-1.5"><span class="bg-indigo-500 text-white w-4 h-4 rounded-full flex items-center justify-center text-[10px]">2</span> 2nd Deposit Bonus (%)</label>
                <div class="relative">
                    <input type="number" step="0.1" min="0" max="1000" name="bonus_2nd" value="<?= $bonus2 ?>" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 pr-10 text-white focus:outline-none focus:border-indigo-500 transition-colors font-bold text-lg" required>
                    <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 font-bold">%</span>
                </div>
            </div>

            <div>
                 <label class="text-xs font-bold text-slate-300 uppercase tracking-widest pl-1 mb-2 block flex items-center gap-1.5"><span class="bg-indigo-500 text-white w-4 h-4 rounded-full flex items-center justify-center text-[10px]">3</span> 3rd Deposit Bonus (%)</label>
                <div class="relative">
                    <input type="number" step="0.1" min="0" max="1000" name="bonus_3rd" value="<?= $bonus3 ?>" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 pr-10 text-white focus:outline-none focus:border-indigo-500 transition-colors font-bold text-lg" required>
                    <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 font-bold">%</span>
                </div>
            </div>

            <button type="submit" class="w-full bg-indigo-600 hover:bg-indigo-500 text-white mt-2 py-3.5 rounded-xl font-bold transition-all shadow-lg shadow-indigo-600/20 border border-indigo-500/50 flex items-center justify-center gap-2">
                <i data-feather="save" class="w-4 h-4"></i> Save Settings
            </button>
        </form>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
